/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class PotionCastingRecipeBuilder
extends AbstractRecipeBuilder<PotionCastingRecipeBuilder> {
    private final class_1792 result;
    private final PotionCastingRecipe.Serializer recipeSerializer;
    private class_1856 bottle = class_1856.field_9017;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = 0;

    public static PotionCastingRecipeBuilder basinRecipe(class_1935 result) {
        return PotionCastingRecipeBuilder.castingRecipe(result.method_8389(), (PotionCastingRecipe.Serializer)TinkerSmeltery.basinPotionRecipeSerializer.get());
    }

    public static PotionCastingRecipeBuilder tableRecipe(class_1935 result) {
        return PotionCastingRecipeBuilder.castingRecipe(result.method_8389(), (PotionCastingRecipe.Serializer)TinkerSmeltery.tablePotionRecipeSerializer.get());
    }

    public PotionCastingRecipeBuilder setFluid(class_6862<class_3611> tagIn, long amount) {
        return this.setFluid(FluidIngredient.of(tagIn, amount));
    }

    public PotionCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public PotionCastingRecipeBuilder setBottle(class_6862<class_1792> tagIn) {
        return this.setBottle(class_1856.method_8106(tagIn));
    }

    public PotionCastingRecipeBuilder setBottle(class_1935 itemIn) {
        return this.setBottle(class_1856.method_8091((class_1935[])new class_1935[]{itemIn}));
    }

    public PotionCastingRecipeBuilder setBottle(class_1856 ingredient) {
        this.bottle = ingredient;
        return this;
    }

    @Override
    public void save(Consumer<class_2444> consumerIn) {
        this.save(consumerIn, class_7923.field_41178.method_10221((Object)this.result));
    }

    @Override
    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept(new Result(id, advancementId));
    }

    private PotionCastingRecipeBuilder(class_1792 result, PotionCastingRecipe.Serializer recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static PotionCastingRecipeBuilder castingRecipe(class_1792 result, PotionCastingRecipe.Serializer recipeSerializer) {
        return new PotionCastingRecipeBuilder(result, recipeSerializer);
    }

    public PotionCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super(ID, advancementID);
        }

        public class_1865<?> method_17800() {
            return PotionCastingRecipeBuilder.this.recipeSerializer;
        }

        public void method_10416(JsonObject json) {
            if (!PotionCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", PotionCastingRecipeBuilder.this.group);
            }
            if (PotionCastingRecipeBuilder.this.bottle != class_1856.field_9017) {
                json.add("bottle", PotionCastingRecipeBuilder.this.bottle.method_8089());
            }
            json.add("fluid", PotionCastingRecipeBuilder.this.fluid.serialize());
            json.addProperty("result", class_7923.field_41178.method_10221((Object)PotionCastingRecipeBuilder.this.result).toString());
            json.addProperty("cooling_time", (Number)PotionCastingRecipeBuilder.this.coolingTime);
        }
    }
}

